#include <iostream>

#include <smart_graph.h>
#include <dimacs.h>
#include <preflow.h>
#include <time_measure.h>

using namespace hugo;

int main(int, char **) {
 
  typedef SmartGraph Graph;
  
  typedef Graph::Node Node;
  typedef Graph::EdgeIt EdgeIt;

  Graph G;
  Node s, t;
  Graph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);
  Timer ts;
  
  std::cout <<
    "\n  Testing preflow.h on a graph with " << 
    G.nodeNum() << " nodes and " << G.edgeNum() << " edges..."
	   << std::endl;


  Graph::EdgeMap<int> flow(G,0);
  Preflow<Graph, int> preflow_test(G, s, t, cap, flow);
  std::cout << "\nCalling run() (flow must be constant zero)..."<<std::endl;
  ts.reset();
  preflow_test.run();
  std::cout << "Elapsed time: " << ts << std::endl;

  Graph::NodeMap<bool> mincut(G);
  preflow_test.minMinCut(mincut); 
  int min_min_cut_value=0;
  Graph::NodeMap<bool> cut(G);
  preflow_test.minCut(cut); 
  int min_cut_value=0;
  Graph::NodeMap<bool> maxcut(G);
  preflow_test.maxMinCut(maxcut); 
  int max_min_cut_value=0;
  EdgeIt e;
  for(G.first(e); G.valid(e); G.next(e)) {
    int c=cap[e];
    if (mincut[G.tail(e)] && !mincut[G.head(e)]) min_min_cut_value+=c;
    if (cut[G.tail(e)] && !cut[G.head(e)]) min_cut_value+=c; 
    if (maxcut[G.tail(e)] && !maxcut[G.head(e)]) max_min_cut_value+=c;
  }

  std::cout << "\nChecking the result: " <<std::endl;  
  std::cout << "Flow value: "<< preflow_test.flowValue() << std::endl;
  std::cout << "Min cut value: "<< min_cut_value << std::endl;
  std::cout << "Min min cut value: "<< min_min_cut_value << std::endl;
  std::cout << "Max min cut value: "<< max_min_cut_value << 
    std::endl;

  if ( preflow_test.flowValue() == min_cut_value &&
       min_cut_value == min_min_cut_value &&
       min_min_cut_value == max_min_cut_value )
    std::cout << "They are equal. " <<std::endl;  





  Preflow<Graph, int> preflow_test2(G, s, t, cap, flow);
  std::cout << "\n\nCalling preflow(GEN_FLOW) with the given maximum flow..."<<std::endl;
  ts.reset();
  preflow_test2.preflow(preflow_test2.GEN_FLOW);
  std::cout << "Elapsed time: " << ts << std::endl;

  Graph::NodeMap<bool> mincut2(G);
  preflow_test.minMinCut(mincut2); 
  int min_min_cut2_value=0;
  Graph::NodeMap<bool> cut2(G);
  preflow_test.minCut(cut2); 
  int min_cut2_value=0;
  Graph::NodeMap<bool> maxcut2(G);
  preflow_test.maxMinCut(maxcut2); 
  int max_min_cut2_value=0;
  for(G.first(e); G.valid(e); G.next(e)) {
    int c=cap[e];
    if (mincut2[G.tail(e)] && !mincut2[G.head(e)]) min_min_cut2_value+=c;
    if (cut2[G.tail(e)] && !cut2[G.head(e)]) min_cut2_value+=c; 
    if (maxcut2[G.tail(e)] && !maxcut2[G.head(e)]) max_min_cut2_value+=c;
  }

  std::cout << "\nThe given flow value is "
	    << preflow_test2.flowValue();

  if ( preflow_test2.flowValue() == min_cut2_value &&
       min_cut2_value == min_min_cut2_value &&
       min_min_cut2_value == max_min_cut2_value )
    std::cout <<", which is equal to all three min cut values." 
	      <<std::endl;  





  Graph::EdgeMap<int> flow3(G,0);
  Preflow<Graph, int> preflow_test3(G, s, t, cap, flow3);
  std::cout << "\n\nCalling preflowPhase0(PREFLOW) on the constant zero flow..."<<std::endl;
  ts.reset();
  preflow_test3.preflowPhase0(preflow_test3.PREFLOW);
  std::cout << "Elapsed time: " << ts << std::endl;
  Graph::NodeMap<bool> actcut3(G);
  std::cout << "\nCalling actMinCut()..."<<std::endl;
  preflow_test3.actMinCut(actcut3); 
  std::cout << "Calling preflowPhase1() on the given flow..."<<std::endl;
  ts.reset();
  preflow_test3.preflowPhase1();
  std::cout << "Elapsed time: " << ts << std::endl;
  
  int act_min_cut3_value=0;
  
  Graph::NodeMap<bool> mincut3(G);
  preflow_test.minMinCut(mincut3); 
  int min_min_cut3_value=0;
  
  Graph::NodeMap<bool> cut3(G);
  preflow_test.minCut(cut3); 
  int min_cut3_value=0;
  
  Graph::NodeMap<bool> maxcut3(G);
  preflow_test.maxMinCut(maxcut3); 
  int max_min_cut3_value=0;
  
  for(G.first(e); G.valid(e); G.next(e)) {
    int c=cap[e];
    if (mincut3[G.tail(e)] && !mincut3[G.head(e)]) min_min_cut3_value+=c;
    if (cut3[G.tail(e)] && !cut3[G.head(e)]) min_cut3_value+=c; 
    if (maxcut3[G.tail(e)] && !maxcut3[G.head(e)]) max_min_cut3_value+=c;
    if (actcut3[G.tail(e)] && !actcut3[G.head(e)]) act_min_cut3_value+=c;
  }

 std::cout << "\nThe min cut value given by actMinCut() after phase 0 is "<<
   act_min_cut3_value;

  if ( preflow_test3.flowValue() == min_cut3_value &&
       min_cut3_value == min_min_cut3_value &&
       min_min_cut3_value == max_min_cut3_value &&
       max_min_cut3_value == act_min_cut3_value ) {
    std::cout << 
      ", which is equal to the given flow value and to all three min cut values after phase 1." 
	      <<std::endl;  
  }





  Graph::EdgeMap<int> flow4(G,0);
  Preflow<Graph, int> preflow_test4(G, s, t, cap, flow4);
  std::cout << 
    "\n\nCalling preflow(PREFLOW) with the constant 0 flow, the result is f..."
	    <<std::endl;
  preflow_test4.preflow(preflow_test4.PREFLOW);

  std::cout << "Swapping the source and the target, "<<std::endl;
  std::cout << "by calling resetSource(t) and resetTarget(s)..."
	    <<std::endl;
  preflow_test4.resetSource(t);
  preflow_test4.resetTarget(s);

  std::cout << 
    "Calling preflow(PREFLOW) to find a maximum t-s flow starting with flow f..."
	    <<std::endl;
  preflow_test4.preflow(preflow_test4.PREFLOW);

  Graph::NodeMap<bool> mincut4(G);
  preflow_test4.minMinCut(mincut4); 
  int min_min_cut4_value=0;
  Graph::NodeMap<bool> cut4(G);
  preflow_test4.minCut(cut4); 
  int min_cut4_value=0;
  Graph::NodeMap<bool> maxcut4(G);
  preflow_test4.maxMinCut(maxcut4); 
  int max_min_cut4_value=0;
  for(G.first(e); G.valid(e); G.next(e)) {
    int c=cap[e];
    if (mincut4[G.tail(e)] && !mincut4[G.head(e)]) min_min_cut4_value+=c;
    if (cut4[G.tail(e)] && !cut4[G.head(e)]) min_cut4_value+=c; 
    if (maxcut4[G.tail(e)] && !maxcut4[G.head(e)]) max_min_cut4_value+=c;
  }

  std::cout << "\nThe given flow value is "
	    << preflow_test4.flowValue();
  
  if ( preflow_test4.flowValue() == min_cut4_value &&
       min_cut4_value == min_min_cut4_value &&
       min_min_cut4_value == max_min_cut4_value )
    std::cout <<", which is equal to all three min cut values." 
	      <<std::endl;  




  Graph::EdgeMap<int> flow5(G,0);
  std::cout << "Resetting the stored flow to constant zero, by calling resetFlow..."
	    <<std::endl;
  preflow_test4.resetFlow(flow5);
  std::cout << 
    "Calling preflow(GEN_FLOW) to find a maximum t-s flow "<<std::endl;
  std::cout << 
    "starting with this constant zero flow..." <<std::endl;
  preflow_test4.preflow(preflow_test4.GEN_FLOW);

  Graph::NodeMap<bool> mincut5(G);
  preflow_test4.minMinCut(mincut5); 
  int min_min_cut5_value=0;
  Graph::NodeMap<bool> cut5(G);
  preflow_test4.minCut(cut5); 
  int min_cut5_value=0;
  Graph::NodeMap<bool> maxcut5(G);
  preflow_test4.maxMinCut(maxcut5); 
  int max_min_cut5_value=0;
  for(G.first(e); G.valid(e); G.next(e)) {
    int c=cap[e];
    if (mincut5[G.tail(e)] && !mincut5[G.head(e)]) min_min_cut5_value+=c;
    if (cut5[G.tail(e)] && !cut5[G.head(e)]) min_cut5_value+=c; 
    if (maxcut5[G.tail(e)] && !maxcut5[G.head(e)]) max_min_cut5_value+=c;
  }

  std::cout << "\nThe given flow value is "
	    << preflow_test4.flowValue();
  
  if ( preflow_test4.flowValue() == min_cut5_value &&
       min_cut5_value == min_min_cut5_value &&
       min_min_cut5_value == max_min_cut5_value )
    std::cout <<", which is equal to all three min cut values." 
	      <<std::endl<<std::endl;  


  return 0;
}
