#ifndef EDGE_MAP_REGISTRY_H
#define EDGE_MAP_REGISTRY_H

#include <vector>

template <typename G, typename E>
class EdgeMapRegistry {
public:
	typedef G Graph;
	typedef E Edge
	
	typedef EdgeMapBase<Graph, Edge> EdgeMapBase;

protected:
	typedef std::vector<EdgeMapBase*> Container; 
	
	Container container;
	
	void add(EdgeMapBase& map_base) {
		if (map_base.graph) {
			map_base.graph->edge_maps.erase(map_base);
		}
		container.push_back(&map_base);
		map_base.graph = this;
		map_base.graph_index = container.size()-1;
	} 
	
	void erase(EdgeMapBase& map_base) {
		if (map_base.graph != this) return;
		container.back()->graph_index = map_base.graph_index; 
		container[map_base.graph_index] = container.back();
		container.pop_back();
		map_base.graph = 0;
	}
	
	void addEdge(Edge& edge) {
		typename Container::iterator it;
		for (it = container.begin(); it != container.end(); ++it) {
			(*it)->add(edge);
		}
	}
	
	void eraseEdge(Edge& edge) {
		typename Container::iterator it;
		for (it = container.begin(); it != container.end(); ++it) {
			(*it)->erase(edge);
		}
	}

	friend class EdgeMapBase;
};

#endif
