#include <iostream>
#include <fstream>

#include "../list_graph.hh"
#include "../marci/dimacs.hh"
#include "f_ed_ka.h"
#include "../marci/time_measure.h"

using namespace marci;

// Use a DIMACS max flow file as stdin.
// read_dimacs_demo < dimacs_max_flow_file

int main(int, char **) {
  typedef ListGraph::EachNodeIt EachNodeIt;
  typedef ListGraph::EachEdgeIt EachEdgeIt;

  ListGraph G;
  EachNodeIt s, t;
  ListGraph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);

  std::cout << "edmonds karp demo..." << std::endl;
  ListGraph::EdgeMap<int> flow(G); //0 flow
  
  int ret;
  double pre_time=currTime();
  ret = maxFlow(G,flow,cap,s,t);
  double post_time=currTime();
  //std::cout << "maximum flow: "<< std::endl;
  //for(EachEdgeIt e=G.first<EachEdgeIt>(); e.valid(); ++e) { 
  //  std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
  //}
  //std::cout<<std::endl;
  std::cout << "elapsed time: " << post_time-pre_time << " sec"<< std::endl; 
  std::cout << "flow value: "<< ret << std::endl;

  return 0;
}
