#include <iter_map.h>
#include <maps.h>

#include <iostream>

using namespace hugo;
using namespace std;

const int N = 3;

typedef StdMap<int,int> BaseMap;
typedef IterableMap<BaseMap, N> TestMap;
typedef IterableBoolMap<BaseMap> TestBoolMap;


template<typename TM>
void print(TM const& m, int N = 3) {
  cout << "Size of the map: " << m.size() << endl;
  for(int i=0; i<N; ++i) {
    cout << "  Class " << i << ". (size=" << m.size(i) << "): " << flush;
    cout << "    ";
    for(typename TM::iterator j = m.begin(i); j!=m.end(i); ++j) {
      cout << " " << *j;
    }
    cout << endl;
  }
}

struct Int {
  int a;

  Int(int b = 5) : a(b) {}
  Int(Invalid) : a(-1) {}

  operator int() const { return a; }

  bool valid() { return a != -1; }
};

typedef StdMap<Int,int> BaseMap2;
typedef IterableBoolMap<BaseMap2> TestBoolMap2;


int main() {

  {
    BaseMap base(344);
    TestMap test(base);


    print(test);

    cout << "Inserting 12 to class 2...\n";
    test.insert(12,2);
    print(test);


    cout << "Inserting 22 to class 2...\n";
    test.insert(22,2);
    print(test);

    cout << "Testing some map values:\n";
    cout << " 12: " << int(test[12]) << endl;

    cout << "Inserting 10 to class 0...\n";
    test.insert(10,0);
    print(test);

    cout << "Testing some map values:\n";
    cout << " 12: " << int(test[12]) << endl;

    cout << "Inserting 11 to class 1...\n";
    test.insert(11,1);
    print(test);

    cout << "Testing some map values:\n";
    cout << " 12: " << int(test[12]) << endl;
    cout << " 22: " << int(test[22]) << endl;
    cout << " 10: " << int(test[10]) << endl;
    cout << " 11: " << int(test[11]) << endl;
    cout << " 42: " << int(test[42]) << endl;

    cout << "Inserting 21 to class 1...\n";
    test.insert(21,1);
    print(test);

    cout << "Inserting 20 to class 1...\n";
    test.insert(20,0);
    print(test);

    cout << "Testing some map values:\n";
    cout << " 12: " << int(test[12]) << endl;
    cout << " 22: " << int(test[22]) << endl;
    cout << " 10: " << int(test[10]) << endl;
    cout << " 20: " << int(test[20]) << endl;
    cout << " 11: " << int(test[11]) << endl;
    cout << " 21: " << int(test[21]) << endl;
    cout << " 42: " << int(test[42]) << endl;

    cout << "Setting 20 to class 2...\n";
    test.set(20,2);
    print(test);
  
    cout << "Setting 10 to class 1...\n";
    test.set(10,1);
    print(test);
  
    cout << "Setting 11 to class 1...\n";
    test.set(11,1);
    print(test);
  
    cout << "Setting 12 to class 1...\n";
    test.set(12,1);
    print(test);
  
    cout << "Setting 21 to class 2...\n";
    test.set(21,2);
    print(test);
  
    cout << "Setting 22 to class 2...\n";
    test.set(22,2);
    print(test);
  
    cout << "Testing some map values:\n";
    cout << " 12: " << int(test[12]) << endl;
    cout << " 22: " << int(test[22]) << endl;
    cout << " 10: " << int(test[10]) << endl;
    cout << " 20: " << int(test[20]) << endl;
    cout << " 11: " << int(test[11]) << endl;
    cout << " 21: " << int(test[21]) << endl;
    cout << " 42: " << int(test[42]) << endl;
  }

  {
    cout << "\n\n\nTesting the IterableBoolMap...\n";

    BaseMap base(344);
    TestBoolMap test(base,true);


    print(test,2);

    cout << "Inserting 12 to class true...\n";
    test.insert(12,true);
    print(test,2);


    cout << "Inserting 22 to class true...\n";
    test.insert(22,true);
    print(test,2);

    cout << "Testing some map values:\n";
    cout << " 12: " << test[12] << endl;

    cout << "Inserting 10 to class false...\n";
    test.insert(10,false);
    print(test,2);

    cout << "Testing some map values:\n";
    cout << " 12: " << test[12] << endl;

    cout << "Inserting 11 to class false...\n";
    test.insert(11,false);
    print(test,2);

    cout << "Testing some map values:\n";
    cout << " 12: " << test[12] << endl;
    cout << " 22: " << test[22] << endl;
    cout << " 10: " << test[10] << endl;
    cout << " 11: " << test[11] << endl;
    cout << " 42: " << test[42] << endl;

    cout << "Setting 10 to class true...\n";
    test.set(10,true);
    print(test,2);
  
    cout << "Setting 11 to class true...\n";
    test.set(11,1);
    print(test,2);
  
    cout << "Setting 12 to class false...\n";
    test.set(12,false);
    print(test,2);
  
    cout << "Setting 22 to class false...\n";
    test.set(22,false);
    print(test,2);
  
    cout << "Testing some map values:\n";
    cout << " 12: " << test[12] << endl;
    cout << " 22: " << test[22] << endl;
    cout << " 10: " << test[10] << endl;
    cout << " 11: " << test[11] << endl;
    cout << " 42: " << test[42] << endl;

  }

  {
    cout << "\n\n\nTest a masikfele iteralasra:\n";

    BaseMap2 base(344);
    TestBoolMap2 test(base,false);

    cout << "Inserting 12 to class true...\n";
    test.insert(12,true);
    print(test,2);

    cout << "Inserting 22 to class true...\n";
    test.insert(22,true);
    print(test,2);

    cout << "Inserting 10 to class false...\n";
    test.insert(10,false);
    print(test,2);

    cout << "Testing some map values:\n";
    cout << " 12: " << test[12] << endl;
    cout << " 22: " << test[22] << endl;
    cout << " 10: " << test[10] << endl;
    cout << " 42: " << test[42] << endl;

    cout << "The elements of the \"true\" class: ";
    Int a;
    for(test.first(a, true); a.valid(); test.next(a)) {
      cout << " " << a;
    }
    cout << endl;

    cout << "Removing 10 from the map...\n";
    test.remove(10);
    print(test,2);
  }
}
