// -*- c++ -*-

// Use a DIMACS max flow file as stdin.
// dim_to_dot < dimacs_max_flow_file > dot_output_file
// This program makes a dot file from a dimacs max flow file. 
// This program can be an aid in making up to date visualized documantation 
// of demo programs.

#include <iostream>
#include <fstream>

#include <lemon/smart_graph.h>
#include <lemon/dimacs.h>

using namespace lemon;

using std::cout;
using std::endl;

int main()
{    
  typedef SmartGraph Graph;

  typedef Graph::Edge Edge;
  typedef Graph::Node Node;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::NodeIt NodeIt;
  typedef Graph::EdgeMap<int> LengthMap;

  Graph g;
  Node s, t;
  LengthMap length(g);

  readDimacs(std::cin, g, length, s, t);

  cout << "digraph lemon_dot_example {" << endl;
  cout << "  node [ shape=ellipse, fontname=Helvetica, fontsize=10 ];" << endl;
  for(NodeIt n(g); n!=INVALID; ++n) {
    if (n==s) {
      cout << "  n" << g.id(n) 
	   << " [ label=\"" << g.id(n) << " (s)\" ]; " << endl;
    } else {
      if (n==t) {
	cout << "  n" << g.id(n) 
	     << " [ label=\"" << g.id(n) << " (t)\" ]; " << endl; 
      } else {
	cout << "  n" << g.id(n) 
	     << " [ label=\"" << g.id(n) << "\" ]; " << endl; 
      }
    }
  }
  cout << "  edge [ shape=ellipse, fontname=Helvetica, fontsize=10 ];" << endl;
  for(EdgeIt e(g); e!=INVALID; ++e) {
    cout << "  n" << g.id(g.source(e)) << " -> " << " n" << g.id(g.target(e))
	 << " [ label=\"" << g.id(e) 
	 << ", length:" << length[e] << "\" ]; " << endl;
  } 
  cout << "}" << endl;
}
