#ifndef NODE_MAP_BASE_H
#define NODE_MAP_BASE_H

template <class G, class K>
class NodeMapBase {
public:
	typedef G Graph;

	typedef K KeyType;
	
	NodeMapBase() : graph(0) {}
	NodeMapBase(Graph& g) : graph(&g) {
		graph->node_maps.add(*this);
	}

	virtual ~NodeMapBase() {
		if (graph) {
			graph.node_maps.erase(*this);
		}
	}
	
protected:
	
	Graph* graph;

	int graph_index;
	
	void init() {
		for (Graph::NodeIt it(g); g.valid(it); g.next(it)) {
			add(it);
		}
	}
	
	void destroy() {
		for (Graph::NodeIt it(g); g.valid(it); g.next(it)) {
			erase(it);
		}
	}
	
	virtual void add(const KeyType&) = 0;
	virtual void erase(const KeyType&) = 0;

	friend class Graph;
};

#endif
