#ifndef EDGE_MAP_BASE_H
#define EDGE_MAP_BASE_H

template <class G, class K>
class EdgeMapBase {
public:
	typedef G Graph;

	typedef K KeyType;
	
	EdgeMapBase() : graph(0) {}
	EdgeMapBase(Graph& g) : graph(&g) {
		graph->edge_maps.add(*this);
	}

	virtual ~EdgeMapBase() {
		if (graph) {
			graph.edge_maps.erase(*this);
		}
	}
	
protected:
	
	Graph* graph;

	int graph_index;
	
	void init() {
		for (Graph::EdgeIt it(g); g.valid(it); g.next(it)) {
			add(it);
		}
	}
	
	void destroy() {
		for (Graph::EdgeIt it(g); g.valid(it); g.next(it)) {
			erase(it);
		}
	}
	
	virtual void add(const KeyType&) = 0;
	virtual void erase(const KeyType&) = 0;

	friend class Graph;
};

#endif
