/* -*- C++ -*-
 * src/hugo/invalid.h - Part of HUGOlib, a generic C++ optimization library
 *
 * Copyright (C) 2004 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#ifndef HUGO_INVALID_H
#define HUGO_INVALID_H

///\file
///\brief Definition of INVALID.

namespace hugo {

  /// Dummy type to make it easier to make invalid iterators.
  
  /// See \ref INVALID, how to use it.
  
  struct Invalid {
  public:
    bool operator==(Invalid) { return true;  }
    bool operator!=(Invalid) { return false; }
    bool operator< (Invalid) { return false; }
  };
  
  /// Invalid iterators.
  
  /// \ref Invalid is a global type that converts to each iterator
  /// in such a way that the value of the target iterator will be invalid.

  // It is also used to convert the \c INVALID constant to the
  // node iterator that makes is possible to write 

  //extern Invalid INVALID;

  //const Invalid &INVALID = *(Invalid *)0;
  const Invalid INVALID = Invalid();

} //namespace hugo

#endif
  
