/* -*- C++ -*-
 * src/hugo/skeletons/maps.h - Part of HUGOlib, a generic C++ optimization library
 *
 * Copyright (C) 2004 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#ifndef HUGO_MAPSKELETON_H
#define HUGO_MAPSKELETON_H

///\ingroup skeletons
///\file
///\brief Map concepts checking classes for testing and documenting.

namespace hugo {

  namespace skeleton {
  
    /// \addtogroup skeletons
    /// @{

    /// Readable map concept
    template<typename K, typename T>
    class ReadMap
    {
    public:
      /// Map's key type.
      typedef K KeyType;    
      /// Map's value type. (The type of objects associated with the keys).
      typedef T ValueType;

      /// Returns the value associated with a key.
      ValueType operator[](const KeyType &k) const {return ValueType();}

      ///Default constructor
      ReadMap() {}
    };


    /// Writable map concept
    template<typename K, typename T>
    class WriteMap
    {
    public:
      /// Map's key type.
      typedef K KeyType;    
      /// Map's value type. (The type of objects associated with the keys).
      typedef T ValueType;

      /// Sets the value associated with a key.
      void set(const KeyType &k,const ValueType &t) {}

      ///Default constructor
      WriteMap() {}
    };

    ///Read/Writable map concept
    template<typename K, typename T>
    class ReadWriteMap : public ReadMap<K,T>,
			    public WriteMap<K,T>
    {
    public:
      /// Map's key type.
      typedef K KeyType;    
      /// Map's value type. (The type of objects associated with the keys).
      typedef T ValueType;

      /// Returns the value associated with a key.
      ValueType operator[](const KeyType &k) const {return ValueType();}
      /// Sets the value associated with a key.
      void set(const KeyType &k,const ValueType &t) {}

      ///Default constructor
      ReadWriteMap() {}
    };
  
  
    ///Dereferable map concept
    template<typename K, typename T>
    class ReferenceMap : public ReadWriteMap<K,T>
    {
    public:
      /// Map's key type.
      typedef K KeyType;    
      /// Map's value type. (The type of objects associated with the keys).
      typedef T ValueType;

    protected:
      ValueType tmp;
    public:
      typedef ValueType& ReferenceType;
      /// Map's const reference type.
      typedef const ValueType& ConstReferenceType;

      ///Returns a reference to the value associated to a key.
      ReferenceType operator[](const KeyType &i) { return tmp; }
      ///Returns a const reference to the value associated to a key.
      ConstReferenceType operator[](const KeyType &i) const
      { return tmp; }
      /// Sets the value associated with a key.
      void set(const KeyType &k,const ValueType &t) { operator[](k)=t; }

      ///Default constructor
      ReferenceMap() {}
    };

    // @}

  } //namespace skeleton
} //namespace hugo
#endif // HUGO_MAPSKELETON_H
