/* -*- C++ -*-
 * src/test/sym_graph_test.cc - Part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2004 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include<iostream>

#include<lemon/concept/sym_graph.h>

#include<lemon/list_graph.h>
#include<lemon/smart_graph.h>
#include<lemon/full_graph.h>

#include"test_tools.h"
#include"graph_test.h"
#include"sym_graph_test.h"

/**
\file
This test makes consistency checks of list graph structures.

G.addNode(), G.addEdge(), G.tail(), G.head()

\todo Checks for empty graphs and isolated points.
conversion.
*/

using namespace lemon;

template<class Graph> void checkPetersen(Graph &G)
{
  typedef typename Graph::NodeIt NodeIt;


  checkGraphNodeList(G,10);
  checkGraphEdgeList(G,30);
  checkGraphSymEdgeList(G,15);

  for(NodeIt n(G);n!=INVALID;++n) {
    checkGraphInEdgeList(G,n,3);
    checkGraphOutEdgeList(G,n,3);
  }  
}

//Compile Graph
template void lemon::checkCompileStaticSymGraph<concept::StaticSymGraph>
(concept::StaticSymGraph &);

template void lemon::checkCompileSymGraph<concept::ExtendableSymGraph>
(concept::ExtendableSymGraph &);

template void lemon::checkCompileErasableSymGraph<concept::ErasableSymGraph>
(concept::ErasableSymGraph &);


//Compile SymSmartGraph
template void lemon::checkCompileSymGraph<SymSmartGraph>(SymSmartGraph &);
template
void lemon::concept::checkCompileGraphFindEdge<SymSmartGraph>(SymSmartGraph &);

//Compile SymListGraph
template void lemon::checkCompileSymGraph<SymListGraph>(SymListGraph &);
template void lemon::checkCompileErasableSymGraph<SymListGraph>(SymListGraph &);
template
void lemon::concept::checkCompileGraphFindEdge<SymListGraph>(SymListGraph &);

int main() 
{
  {
    SymSmartGraph G;
    addSymPetersen(G);
    checkPetersen(G);
  }
  {
    SymListGraph G;
    addSymPetersen(G);
    checkPetersen(G);
  }

  ///\file
  ///\todo map tests.
  ///\todo copy constr tests.

  std::cout << __FILE__ ": All tests passed.\n";

  return 0;
}
