#include <lemon/concept_check.h>
#include <lemon/concept/maps.h>
#include <lemon/maps.h>

#include "test_tools.h"

using namespace lemon;
using namespace lemon::concept;

struct A {};
struct B {};

typedef ReadMap<A,double> DoubleMap;

int main()
{ // checking graph components
  
  checkConcept<ReadMap<A,B>, ReadMap<A,B> >();
  checkConcept<WriteMap<A,B>, WriteMap<A,B> >();
  checkConcept<ReadWriteMap<A,B>, ReadWriteMap<A,B> >();
  checkConcept<ReferenceMap<A,B,B&,const B&>, ReferenceMap<A,B,B&,const B&> >();

  checkConcept<ReadMap<A,double>, AddMap<DoubleMap,DoubleMap> >();
  checkConcept<ReadMap<A,double>, SubMap<DoubleMap,DoubleMap> >();
  checkConcept<ReadMap<A,double>, MulMap<DoubleMap,DoubleMap> >();
  checkConcept<ReadMap<A,double>, DivMap<DoubleMap,DoubleMap> >();
  checkConcept<ReadMap<A,double>, NegMap<DoubleMap> >();
  checkConcept<ReadMap<A,double>, AbsMap<DoubleMap> >();
  
  checkConcept<ReadMap<B,double>, ComposeMap<DoubleMap,ReadMap<B,A> > >();

  std::cout << __FILE__ ": All tests passed.\n";
  
  return 0;
}
