#ifndef NODE_MAP_REGISTRY_H
#define NODE_MAP_REGISTRY_H

#include <vector>

#include "node_map_base.h"

template <typename G, typename E>
class NodeMapRegistry {
public:
	typedef G Graph;
	typedef E Node
	
	typedef NodeMapBase<Graph, Node> NodeMapBase;

protected:
	typedef std::vector<NodeMapBase*> Container; 
	
	Container container;
	
	void add(NodeMapBase& map_base) {
		if (map_base.graph) {
			map_base.graph->node_maps.erase(map_base);
		}
		container.push_back(&map_base);
		map_base.graph = this;
		map_base.graph_index = container.size()-1;
	} 
	
	void erase(NodeMapBase& map_base) {
		if (map_base.graph != this) return;
		container.back()->graph_index = map_base.graph_index; 
		container[map_base.graph_index] = container.back();
		container.pop_back();
		map_base.graph = 0;
	}
	
	void add(Node& node) {
		typename Container::iterator it;
		for (it = container.begin(); it != container.end(); ++it) {
			(*it)->add(node);
		}
	}
	
	void erase(Node& node) {
		typename Container::iterator it;
		for (it = container.begin(); it != container.end(); ++it) {
			(*it)->erase(node);
		}
	}

	friend class NodeMapBase;
};

#endif
