// -*-mode: c++; -*-

#include <invalid.h>

/// The namespace of HugoLib
namespace hugo {

  // @defgroup empty_graph The EmptyGraph class
  // @{

  /// An empty graph class.
  
  /// This class provides all the common features of a grapf structure,
  /// however completely without implementations or real data structures
  /// behind the interface.
  /// All graph algorithms should compile with this class, but it will not
  /// run properly, of course.
  ///
  /// It can be used for checking the interface compatibility,
  /// or it can serve as a skeleton of a new graph structure.
  /// 
  /// Also, you will find here the full documentation of a certain graph
  /// feature, the documentation of a real graph imlementation
  /// like @ref ListGraph or
  /// @ref SmartGraph will just refer to this structure.
  class EmptyGraph
  {
  public:
    
    /// The base type of the node iterators.
    class Node {
    public:
      /// @warning The default constructor sets the iterator
      /// to an undefined value.
      Node() {}   //FIXME
      /// Initialize the iterator to be invalid
      Node(Invalid) {};
      //Node(const Node &) {} 
      bool operator==(Node n) const { return true; } //FIXME
      bool operator!=(Node n) const { return true; } //FIXME
    };
    
    /// This iterator goes through each node.
    class NodeIt : public Node {
    public:
      /// @warning The default constructor sets the iterator
      /// to an undefined value.
      NodeIt() {} //FIXME
      /// Initialize the iterator to be invalid
      NodeIt(Invalid) {};
      /// Sets the iterator to the first node of \c G.
      NodeIt(const EmptyGraph &G) {}
      NodeIt(const NodeIt &) {} //FIXME
    };
    
    
    /// The base type of the edge iterators.
    class Edge {
    public:
      /// @warning The default constructor sets the iterator
      /// to an undefined value.
      Edge() {}   //FIXME
      /// Initialize the iterator to be invalid
      Edge(Invalid) {};
      //Edge(const Edge &) {} 
      bool operator==(Edge n) const { return true; } //FIXME
      bool operator!=(Edge n) const { return true; } //FIXME    
    };
    
    /// This iterator goes trought the outgoing edges of a certain graph.
    
    class OutEdgeIt : public Edge {
    public:
      /// @warning The default constructor sets the iterator
      /// to an undefined value.
      OutEdgeIt() {}
      /// Initialize the iterator to be invalid
      OutEdgeIt(Invalid) {};
      /// This constructor sets the iterator to first outgoing edge.
    
      /// This constructor set the iterator to the first outgoing edge of
      /// node
      ///@param n the node
      ///@param G the graph
      OutEdgeIt(const EmptyGraph & G, Node n) {}
    };

    class InEdgeIt : public Edge {
    public:
      /// @warning The default constructor sets the iterator
      /// to an undefined value.
      InEdgeIt() {}
      /// Initialize the iterator to be invalid
      InEdgeIt(Invalid) {};
      InEdgeIt(const EmptyGraph &, Node) {}    
    };
    //  class SymEdgeIt : public Edge {};
    class EdgeIt : public Edge {
    public:
      /// @warning The default constructor sets the iterator
      /// to an undefined value.
      EdgeIt() {}
      /// Initialize the iterator to be invalid
      EdgeIt(Invalid) {};
      EdgeIt(const EmptyGraph &) {}
    };

    /// First node of the graph.

    /// \post \c i and the return value will be the first node.
    ///
    NodeIt &first(NodeIt &i) const { return i;}

    /// The first outgoing edge.
    InEdgeIt &first(InEdgeIt &i, Node n) const { return i;}
    /// The first incoming edge.
    OutEdgeIt &first(OutEdgeIt &i, Node n) const { return i;}
    //  SymEdgeIt &first(SymEdgeIt &, Node) const { return i;}
    /// The first edge of the Graph.
    EdgeIt &first(EdgeIt &i) const { return i;}

//     Node getNext(Node) const {}
//     InEdgeIt getNext(InEdgeIt) const {}
//     OutEdgeIt getNext(OutEdgeIt) const {}
//     //SymEdgeIt getNext(SymEdgeIt) const {}
//     EdgeIt getNext(EdgeIt) const {}

    /// Go to the next node.
    Node &next(Node &i) const { return i;}
    /// Go to the next incoming edge.
    InEdgeIt &next(InEdgeIt &i) const { return i;}
    /// Go to the next outgoing edge.
    OutEdgeIt &next(OutEdgeIt &i) const { return i;}
    //SymEdgeIt &next(SymEdgeIt &) const {}
    /// Go to the next edge.
    EdgeIt &next(EdgeIt &i) const { return i;}

    ///Gives back the head node of an edge.
    Node head(Edge) const { return INVALID; }
    ///Gives back the tail node of an edge.
    Node tail(Edge) const { return INVALID; }
  
    //   Node aNode(InEdgeIt) const {}
    //   Node aNode(OutEdgeIt) const {}
    //   Node aNode(SymEdgeIt) const {}

    //   Node bNode(InEdgeIt) const {}
    //   Node bNode(OutEdgeIt) const {}
    //   Node bNode(SymEdgeIt) const {}

    /// Checks if a node iterator is valid
    bool valid(const Node) const { return true;};
    /// Checks if an edge iterator is valid
    bool valid(const Edge) const { return true;};

    ///Gives back the \e id of a node.
    int id(const Node) const { return 0;};
    ///Gives back the \e id of an edge.
    int id(const Edge) const { return 0;};

    //void setInvalid(Node &) const {};
    //void setInvalid(Edge &) const {};
  
    Node addNode() { return INVALID;}
    Edge addEdge(Node tail, Node head) { return INVALID;}
    
    void erase(Node n) {}
    void erase(Edge e) {}

    void clear() {}

    int nodeNum() { return 0;}
    int edgeNum() { return 0;}

    EmptyGraph() {};
    EmptyGraph(const EmptyGraph &G) {};
  
  

    ///Read/write map from the nodes to type \c T.
    template<class T> class NodeMap
    {
    public:
      typedef T ValueType;
      typedef Node KeyType;

      NodeMap(const EmptyGraph &G) {}
      NodeMap(const EmptyGraph &G, T t) {}

      void set(Node i, T t) {}
      T get(Node i) const {return *(T*)NULL;}  //FIXME: Is it necessary
      T &operator[](Node i) {return *(T*)NULL;}
      const T &operator[](Node i) const {return *(T*)NULL;}

      void update() {}
      void update(T a) {}   //FIXME: Is it necessary
    };

    ///Read/write map from the edges to type \c T.
    template<class T> class EdgeMap
    {
    public:
      typedef T ValueType;
      typedef Edge KeyType;

      EdgeMap(const EmptyGraph &G) {}
      EdgeMap(const EmptyGraph &G, T t) {}
    
      void set(Edge i, T t) {}
      T get(Edge i) const {return *(T*)NULL;}
      T &operator[](Edge i) {return *(T*)NULL;}
    
      void update() {}
      void update(T a) {}   //FIXME: Is it necessary
    };
  };

  // @}

};



// class EmptyBipGraph : public EmptyGraph
// {
//   class ANode {};
//   class BNode {};

//   ANode &next(ANode &) {}
//   BNode &next(BNode &) {}

//   ANode &getFirst(ANode &) const {}
//   BNode &getFirst(BNode &) const {}

//   enum NodeClass { A = 0, B = 1 };
//   NodeClass getClass(Node n) {}

// }
