#ifndef MAP_REGISTRY_H
#define MAP_REGISTRY_H

#include <vector>


namespace hugo {
	template <typename G, typename K, typename KIt>
	class MapRegistry;
}

#include "map_base.h"

namespace hugo {

	template <typename G, typename K, typename KIt>
	class MapRegistry {
	public:
		typedef G Graph;
		typedef K Key;
		typedef KIt KeyIt;
	
		typedef MapBase<Graph, Key, KIt> Map;
		friend class Base;
	
	protected:
	
		typedef std::vector<Map*> Container; 
	  Container container;

		Graph* graph;		
		
		
	public:
	
		MapRegistry(Graph& g) : container(0), graph(&g) {}
				
		~MapRegistry() {
			typename Container::iterator it;
			for (it = container.begin(); it != container.end(); ++it) {
				(*it)->destroy(*graph);
				(*it)->registry = 0;
			}
		}
	
	private:
		MapRegistry(const MapRegistry& ) {}
		MapRegistry& operator=(const MapRegistry& ) {}
	
	public:
	
		void add(Map& map) {
			if (map.registry) {
				map.registry->erase(map);
			}
			container.push_back(&map);
			map.registry = this;
			map.registry_index = container.size()-1;
			map.init(*graph);
		} 
	
		void erase(Map& map_base) {
			map_base.destroy(*graph);
			container.back()->registry_index = map_base.registry_index; 
			container[map_base.registry_index] = container.back();
			container.pop_back();
			map_base.registry = 0;
		}
	
		
		void add(Key& key) {
			typename Container::iterator it;
			for (it = container.begin(); it != container.end(); ++it) {
				(*it)->add(key);
			}
		}	
		
		void erase(Key& key) {
			typename Container::iterator it;
			for (it = container.begin(); it != container.end(); ++it) {
				(*it)->erase(key);
			}
		}

		Graph& getGraph() {
			return *graph;
		}


	};

}

#endif
