#include "simann.h"
#include <cstdlib>
#include <cmath>
#include <iostream>

using namespace lemon;

class MyController : public SimAnnBase::Controller {
public:
  long iter, last_impr, max_iter, max_no_impr;
  double temp, annealing_factor;
  MyController() {
    iter = last_impr = 0;
    max_iter = 500000;
    max_no_impr = 20000;
    annealing_factor = 0.9999;
    temp = 1000;
  }
  void acceptEvent() {
    iter++;
  }
  void improveEvent() {
    last_impr = iter;
  }
  void rejectEvent() {
    iter++;
  }
  bool next() {
    temp *= annealing_factor;
    bool quit = (iter > max_iter) || (iter - last_impr > max_no_impr);
    return !quit;
  }
  bool accept(double cost_diff) {
    return (drand48() <= exp(cost_diff / temp));
  }
};

class MyEntity {
public:
  double mutate() { return 10.0; }
};

int main() {
  SimAnn<MyEntity> simann;
  MyController ctrl;
  simann.setController(ctrl);
  MyEntity ent;
  simann.setEntity(ent);
  simann.run();
}
