#ifndef BENCHMARK_TOOLS_H
#define BENCHMARK_TOOLS_H

#include<string>
#include<iostream>
#include<iomanip>
#include<lemon/time_measure.h>

extern std::string test_name;
extern std::string instance_name;

extern const std::string DATADIR_PATH;


inline void logTime(const std::string &_instance_name,
		    const std::string &subtest_name,
		    const lemon::TimeStamp &time)
{
  std::cout << "*** " << test_name
	    << ' ' << _instance_name
	    << ' ' << subtest_name
	    << ' ' << std::setiosflags(std::ios::fixed) << std::setprecision(4)
	    << time.realTime() << ' '
            << time.realTime()/(time.userTime()+time.systemTime()) - 1.0
            << std::endl;
}

inline void logTime(const std::string &subtest_name,
		    const lemon::TimeStamp &time)
{
  logTime(instance_name,subtest_name,time);
}

#endif
