#! /usr/bin/env python

import sys
import os
import copy
import re

def sec_inc(section, lev):
    while len(section)<lev:
        section.append(0)
    section[lev-1]+=1
    section=section[:lev]
    return section

def format_sec(sec):
    s=""
    for i in sec:
        s+=str(i)+'.'
    return s

section = [];
toc={}
ind={}

prev_page=''
for l in open("toc.txt").readlines():
    sl = l.split()
    if len(sl)==2 and len(sl[0])>0: 
        lev=len(sl[0])
        section=sec_inc(section,lev)
        t_sec=copy.copy(section)
        t_link=sl[1];
        print format_sec(t_sec),t_link
        ind[t_link]=[t_sec,'','']
        if lev==1:
            ind[t_link][1]=prev_page
            if prev_page:
                ind[prev_page][2]=t_link
            prev_page=t_link
        toc[format_sec(t_sec)]=t_link

for doxfile in os.listdir('.'):
    if doxfile[-4:]=='.dox':
        print 'Generate ',doxfile
        page=''
        fo=open(os.path.join("gen-dox",doxfile),"w")
        for l in open(doxfile).readlines():
            gr = re.match(r"(^[[]PAGE[]].*[[]PAGE[]])?(^[[]SEC[]].*[[]SEC[]])?(^[[]TRAILER[]])?(^[[]TOC[]])?(.*)$", l).groups()
            if gr[0]:
                page=gr[0][6:-6]
                fo.write("\page %s %s%s\n"%(page,
                                            format_sec(ind[page][0]),gr[4]))
            elif gr[1]:
                sec=gr[1][5:-5]
                fo.write("\section %s %s%s\n"%(sec,
                                               format_sec(ind[sec][0]),gr[4]))
            elif gr[2]:
                prev_page=ind[page][1]
                prev_str= ( '\\ref '+prev_page ) if prev_page else ''
                next_page=ind[page][2]
                next_str= ( '\\ref '+next_page ) if next_page else ''
                fo.write('<< %s | \\ref toc "Home" | %s >>\n'%\
                             (prev_str,next_str))
            elif gr[3]:
                secs = [ x for x in toc]
                secs.sort()
                for num in secs:
                    fo.write("%s - \\ref %s\n"%(' '*(len(num)-2),toc[num]))
            else:
                fo.write(gr[4]+'\n')
        fo.close()
