// -*- c++ -*-
#include <iostream>
#include <fstream>

#include <list_graph.h>
#include <smart_graph.h>
#include <dimacs.h>
#include <edmonds_karp.h>
#include <time_measure.h>
//#include <graph_wrapper.h>
#include <preflow.h>

using namespace hugo;

// Use a DIMACS max flow file as stdin.
// read_dimacs_demo < dimacs_max_flow_file


//   struct Ize {
//   };
  
//   struct Mize {
//     Ize bumm;
//   };

//   template <typename B>
//     class Huha {
//     public:
//       int u;
//       B brr;
//     };


int main(int, char **) {

  typedef ListGraph MutableGraph;

//  typedef SmartGraph Graph;
  typedef ListGraph Graph;
  typedef Graph::Node Node;
  typedef Graph::EdgeIt EdgeIt;


//   Mize mize[10];
//   Mize bize[0];
//   Mize zize;
//   typedef Mize Tize[0];

//   std::cout << &zize << " " << sizeof(mize) << sizeof(Tize) << std::endl;
//   std::cout << sizeof(bize) << std::endl;


//   Huha<Tize> k;
//   std::cout << sizeof(k) << std::endl;


//   struct Bumm {
//     //int a;
//     bool b;
//   };

//   std::cout << sizeof(Bumm) << std::endl;


  Graph G;
  Node s, t;
  Graph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);

  {
    std::cout << "preflow ..." << std::endl;
    Graph::EdgeMap<int> flow(G); //0 flow

    Timer ts;
    ts.reset();

    Preflow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > 
      max_flow_test(G, s, t, cap, flow);
    max_flow_test.run();
//    int i=0;
//    while (max_flow_test.augmentOnBlockingFlow<MutableGraph>()) { 
//     for(EdgeIt e=G.template first<EdgeIt>(); e.valid(); ++e) { 
//       std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
//     }
//     std::cout<<std::endl;
//      ++i; 
//    }

//   std::cout << "maximum flow: "<< std::endl;
//   for(EdgeIt e=G.first<EdgeIt>(); e.valid(); ++e) { 
//     std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
//   }
//   std::cout<<std::endl;
    std::cout << "elapsed time: " << ts << std::endl;
//    std::cout << "number of augmentation phases: " << i << std::endl; 
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }

  {
    std::cout << "physical blocking flow augmentation ..." << std::endl;
    Graph::EdgeMap<int> flow(G); //0 flow

    Timer ts;
    ts.reset();

    MaxFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > 
      max_flow_test(G, s, t, cap, flow);
    int i=0;
    while (max_flow_test.augmentOnBlockingFlow<MutableGraph>()) { 
//     for(EdgeIt e=G.template first<EdgeIt>(); e.valid(); ++e) { 
//       std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
//     }
//     std::cout<<std::endl;
      ++i; 
    }

//   std::cout << "maximum flow: "<< std::endl;
//   for(EdgeIt e=G.first<EdgeIt>(); e.valid(); ++e) { 
//     std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
//   }
//   std::cout<<std::endl;
    std::cout << "elapsed time: " << ts << std::endl;
    std::cout << "number of augmentation phases: " << i << std::endl; 
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }

  {
    std::cout << "faster physical blocking flow augmentation ..." << std::endl;
    Graph::EdgeMap<int> flow(G); //0 flow

    Timer ts;
    ts.reset();

    MaxFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > 
      max_flow_test(G, s, t, cap, flow);
    int i=0;
    while (max_flow_test.augmentOnBlockingFlow1<MutableGraph>()) { 
//     for(EdgeIt e=G.template first<EdgeIt>(); e.valid(); ++e) { 
//       std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
//     }
//     std::cout<<std::endl;
      ++i; 
    }

//   std::cout << "maximum flow: "<< std::endl;
//   for(EdgeIt e=G.first<EdgeIt>(); e.valid(); ++e) { 
//     std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
//   }
//   std::cout<<std::endl;
    std::cout << "elapsed time: " << ts << std::endl;
    std::cout << "number of augmentation phases: " << i << std::endl; 
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }

  {
    std::cout << "on-the-fly blocking flow augmentation ..." << std::endl;
    Graph::EdgeMap<int> flow(G); //0 flow

    Timer ts;
    ts.reset();

    MaxFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > 
      max_flow_test(G, s, t, cap, flow);
    int i=0;
    while (max_flow_test.augmentOnBlockingFlow2()) { 
//     for(EdgeIt e=G.template first<EdgeIt>(); e.valid(); ++e) { 
//       std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
//     }
//     std::cout<<std::endl;
      ++i; 
    }

//   std::cout << "maximum flow: "<< std::endl;
//   for(EdgeIt e=G.first<EdgeIt>(); e.valid(); ++e) { 
//     std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
//   }
//   std::cout<<std::endl;
    std::cout << "elapsed time: " << ts << std::endl;
    std::cout << "number of augmentation phases: " << i << std::endl; 
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }

  {
    std::cout << "on-the-fly shortest path augmentation ..." << std::endl;
    Graph::EdgeMap<int> flow(G); //0 flow

    Timer ts;
    ts.reset();

    MaxFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > 
      max_flow_test(G, s, t, cap, flow);
    int i=0;
    while (max_flow_test.augmentOnShortestPath()) { 
//     for(EdgeIt e=G.template first<EdgeIt>(); e.valid(); ++e) { 
//       std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
//     }
//     std::cout<<std::endl;
      ++i; 
    }

//   std::cout << "maximum flow: "<< std::endl;
//   for(EdgeIt e=G.first<EdgeIt>(); e.valid(); ++e) { 
//     std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
//   }
//   std::cout<<std::endl;
    std::cout << "elapsed time: " << ts << std::endl;
    std::cout << "number of augmentation phases: " << i << std::endl; 
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }


  return 0;
}
