/* -*- mode: C++; indent-tabs-mode: nil; -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library.
 *
 * Copyright (C) 2003-2009
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include<lemon/arg_parser.h>
#include<lemon/list_graph.h>
#include<lemon/glpk.h>

///The main entry point
int main(int argc, char **argv)
{

  lemon::ArgParser ap(argc,argv);
  ap.run();

  lemon::ListGraph g;
  g.addNode();
  
  typedef lemon::GlpkLp Solver;
  Solver lp;
  Solver::Col x = lp.addCol();
  Solver::Col y = lp.addCol();
  lp.colLowerBound(x,0);
  lp.colLowerBound(y,0);
  lp.addRow(3<=x+2*y<=10);
  lp.obj(-4*x+3*y);
  lp.max();
  lp.solve();

}
