/***************************************************************
 * Name:      conntestMain.cpp
 * Purpose:   Code for Application Frame
 * Author:     ()
 * Created:   2010-04-06
 * Copyright:  ()
 * License:
 **************************************************************/

#include <lemon/connectivity.h>
#include <lemon/list_graph.h>
//#include <lemon/adaptors.h>

using namespace lemon;

#include "wx_pch.h"
#include "conntestMain.h"
#include <wx/msgdlg.h>

//(*InternalHeaders(conntestFrame)
#include <wx/intl.h>
#include <wx/string.h>
//*)

//helper functions
enum wxbuildinfoformat {
    short_f, long_f };

wxString wxbuildinfo(wxbuildinfoformat format)
{
    wxString wxbuild(wxVERSION_STRING);

    if (format == long_f )
    {
#if defined(__WXMSW__)
        wxbuild << _T("-Windows");
#elif defined(__UNIX__)
        wxbuild << _T("-Linux");
#endif

#if wxUSE_UNICODE
        wxbuild << _T("-Unicode build");
#else
        wxbuild << _T("-ANSI build");
#endif // wxUSE_UNICODE
    }

    return wxbuild;
}

//(*IdInit(conntestFrame)
const long conntestFrame::ID_APP_PANEL = wxNewId();
const long conntestFrame::ID_CLOSE_BUTTON = wxNewId();
const long conntestFrame::ID_CLOSE_APP_PANEL = wxNewId();
const long conntestFrame::idMenuQuit = wxNewId();
const long conntestFrame::idMenuAbout = wxNewId();
const long conntestFrame::ID_STATUSBAR1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(conntestFrame,wxFrame)
    //(*EventTable(conntestFrame)
    //*)
END_EVENT_TABLE()

conntestFrame::conntestFrame(wxWindow* parent,wxWindowID id)
{
    //(*Initialize(conntestFrame)
    wxGridSizer* closeAppGridSizer;
    wxMenuItem* MenuItem2;
    wxMenuItem* MenuItem1;
    wxMenu* Menu1;
    wxMenuBar* MenuBar1;
    wxFlexGridSizer* appFlexGridSizer;
    wxMenu* Menu2;

    Create(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_FRAME_STYLE, _T("id"));
    SetClientSize(wxSize(500,600));
    appFlexGridSizer = new wxFlexGridSizer(2, 1, 0, 0);
    appFlexGridSizer->AddGrowableCol(0);
    appFlexGridSizer->AddGrowableRow(0);
    appPanel = new wxPanel(this, ID_APP_PANEL, wxDefaultPosition, wxSize(200,200), wxTAB_TRAVERSAL, _T("ID_APP_PANEL"));
    appFlexGridSizer->Add(appPanel, 1, wxALL|wxEXPAND|wxALIGN_LEFT|wxALIGN_BOTTOM, 1);
    closeAppPanel = new wxPanel(this, ID_CLOSE_APP_PANEL, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_CLOSE_APP_PANEL"));
    closeAppGridSizer = new wxGridSizer(0, 1, 0, 0);
    closeButton = new wxButton(closeAppPanel, ID_CLOSE_BUTTON, _("Close"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_CLOSE_BUTTON"));
    closeAppGridSizer->Add(closeButton, 1, wxALL|wxALIGN_RIGHT|wxALIGN_BOTTOM, 1);
    closeAppPanel->SetSizer(closeAppGridSizer);
    closeAppGridSizer->Fit(closeAppPanel);
    closeAppGridSizer->SetSizeHints(closeAppPanel);
    appFlexGridSizer->Add(closeAppPanel, 1, wxALL|wxEXPAND|wxALIGN_LEFT|wxALIGN_BOTTOM, 1);
    SetSizer(appFlexGridSizer);
    MenuBar1 = new wxMenuBar();
    Menu1 = new wxMenu();
    MenuItem1 = new wxMenuItem(Menu1, idMenuQuit, _("Quit\tAlt-F4"), _("Quit the application"), wxITEM_NORMAL);
    Menu1->Append(MenuItem1);
    MenuBar1->Append(Menu1, _("&File"));
    Menu2 = new wxMenu();
    MenuItem2 = new wxMenuItem(Menu2, idMenuAbout, _("About\tF1"), _("Show info about this application"), wxITEM_NORMAL);
    Menu2->Append(MenuItem2);
    MenuBar1->Append(Menu2, _("Help"));
    SetMenuBar(MenuBar1);
    StatusBar1 = new wxStatusBar(this, ID_STATUSBAR1, 0, _T("ID_STATUSBAR1"));
    int __wxStatusBarWidths_1[1] = { -1 };
    int __wxStatusBarStyles_1[1] = { wxSB_NORMAL };
    StatusBar1->SetFieldsCount(1,__wxStatusBarWidths_1);
    StatusBar1->SetStatusStyles(1,__wxStatusBarStyles_1);
    SetStatusBar(StatusBar1);
    appFlexGridSizer->SetSizeHints(this);

    Connect(ID_CLOSE_BUTTON,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&conntestFrame::OnQuit);
    Connect(idMenuQuit,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&conntestFrame::OnQuit);
    Connect(idMenuAbout,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&conntestFrame::OnAbout);
    //*)

    buildGraph();
}

conntestFrame::~conntestFrame()
{
    //(*Destroy(conntestFrame)
    //*)
}

void conntestFrame::OnQuit(wxCommandEvent& event)
{
    Close();
}

void conntestFrame::OnAbout(wxCommandEvent& event)
{
    wxString msg = wxbuildinfo(long_f);
    wxMessageBox(msg, _("Welcome to..."));
}

void conntestFrame::buildGraph()
{
  typedef ListDigraph Digraph;
  typedef ListDigraph::Node Node;

    Digraph d;
    Digraph::NodeMap<int> order(d);
    Node one, two, three;


    one = d.addNode();
    order[one]= 1;
    two = d.addNode();
    order[two] = 2;
    three = d.addNode();
    order[three]= 3;
    d.addArc(one,two);
    d.addArc(one, three);
    d.addArc(two, three);
}
